<?
$thispath =	dirname(__FILE__) . DIRECTORY_SEPARATOR;
require_once($thispath . "classUsersdb.php");

define('GUEST_NAME',$config["GUESTNAME"]);
define('GUEST_GROUP',$config["GUESTGROUP"]);
define('ADMIN_GROUP',$config["ADMINGROUP"]);


class Users extends Userdb
{

   private $_username;
   private $_loginid;
   private $_usergroup;
   private $_time;
   private $_logged_in;
   private $_userinfo;
   private $_url;
   private $_referrer;
   private $_cookname;
   private $_cookid;
   private $form;


   public function __construct($form,$db)
   {
   	  $this->_username 	= NULL;
      $this->_loginid  	= NULL;
      $this->_usergroup = NULL;
      $this->_time 		= NOWTIME;
      $this->_logged_in	= NULL;
      $this->_userinfo  = array();
      $this->_url		= NULL;
      $this->_referrer	= NULL;
      $this->_cookname 	= "user";
      $this->_cookid	= "sid";
      $this->form		= $form;
      parent::__construct($db);

   }


	public function getUserinfo ()
	{
        if($this->_logged_in)
        {
			return($this->_userinfo);
		}
		else
		{
          $info = array(
          	'name' 	=> GUEST_NAME,
          	'group' => GUEST_GROUP
          );

          $this->_userinfo =  $info;

          return($this->_userinfo);

		}

	}


   public function isloggedIn ()
   {

		if($this->_logged_in)
		{
	        return(true);
		}
		else
		{
			return(false);
		}
   }

   public function startUserSession()
   {
      session_start();


      $this->_logged_in = $this->doCheckLogin();

      if(!$this->_logged_in)
      {
         $this->_username 	   	=  GUEST_NAME;
         $_SESSION['username'] 	=  GUEST_NAME;
         $this->_usergroup 		= GUEST_GROUP;

      }
      else
      {

         $this->doUpdateLastActive($this->_username);
      }

      if(isset($_SESSION['url']))
      {
         $this->_referrer = $_SESSION['url'];
      }
      else
      {
         $this->_referrer = "/";
      }

      $this->_url 	= $_SESSION['url'] 	= $_SERVER['PHP_SELF'];
      $_SESSION['HTTP_REFERER'] 		= $_SERVER["HTTP_REFERER"];
   }


   public function doCheckLogin()
   {


      if(isset($_COOKIE[PREFIXESCOOKIE.$this->_cookname]) && isset($_COOKIE[PREFIXESCOOKIE.$this->_cookid]))
      {
         $this->_username 	= $_SESSION['username'] = $GLOBALS['clean']->CleanInput($_COOKIE[PREFIXESCOOKIE.$this->_cookname]);
         $this->_loginid   	= $_SESSION['loginid']  = $GLOBALS['clean']->CleanInput($_COOKIE[PREFIXESCOOKIE.$this->_cookid]);
      }


      if(isset($_SESSION['username']) && isset($_SESSION['loginid']) &&
         $_SESSION['username'] != GUEST_NAME)
      {

         if(!$this->doconfirmLoginID($_SESSION['username'], $_SESSION['loginid']))
         {
            unset($_SESSION['username']);
            unset($_SESSION['loginid']);
            return false;
         }


         $this->_userinfo  	= 	$this->doGetClientInfo($_SESSION['username']);
         $this->_username  	= 	$this->_userinfo['name'];
         $this->_loginid   	= 	$this->_userinfo['loginid'];
         $this->_usergroup 	= 	$this->_userinfo['group'];

         $this->doUpdateLastActive($this->_username);

         return true;
      }

      else{

         return false;
      }
   }


   public function login($subuser, $subpass, $subremember)
   {



      $result = $this->doConfirmLogin($subuser,$subpass);

      if(!$result)
      {

         return(FALSE);

      }
      else
      {

		  $this->_userinfo  		= $this->doGetClientInfo($subuser);
		  $this->_username  		= $this->_userinfo['name'];
		  $_SESSION['username'] 	= $this->_userinfo['name'];

		  $this->_loginid  			= $this->generateRandID();

		  $_SESSION['loginid'] 		=  $this->_loginid;


		  $_SESSION['lastlogin']  = $this->_userinfo['lastlogin'];
		  $_SESSION['lastip']  	  = $this->_userinfo['lastip'];

		  $this->doupdateClientField($this->_username, "loginid", $this->_loginid);
		  $this->doupdateClientField($this->_username, "lastlogin", NOWTIME);
		  $this->doupdateClientField($this->_username, "lastip", $this->get_client_ip());

		  if($subremember){
		    setcookie(PREFIXESCOOKIE.$this->_cookname, $this->_username, NOWTIME + COOK_EXPIRE, COOK_PATH);
		    setcookie(PREFIXESCOOKIE.$this->_cookid,   $this->_loginid,  NOWTIME + COOK_EXPIRE, COOK_PATH);

		  }

		  $this->_logged_in = true;
		  /* Login  successfully */
		  return true;
      }

   }


	private function get_client_ip()
	{
		$v='';
		$v= (!empty($_SERVER['REMOTE_ADDR']))?$_SERVER['REMOTE_ADDR'] :((!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) ? $_SERVER['HTTP_X_FORWARDED_FOR']: @getenv('REMOTE_ADDR'));
		if(isset($_SERVER['HTTP_CLIENT_IP']))
		$v=$_SERVER['HTTP_CLIENT_IP'];

		return htmlspecialchars($v,ENT_QUOTES);
	}


   public function logout()
   {


      if(isset($_COOKIE[PREFIXESCOOKIE.$this->_cookname]) && isset($_COOKIE[PREFIXESCOOKIE.$this->_cookid]))
      {

		    setcookie(PREFIXESCOOKIE.$this->_cookname,"", 1, COOK_PATH);
		    setcookie(PREFIXESCOOKIE.$this->_cookid,"", 1, COOK_PATH);
      }

      unset($_SESSION['username']);
      unset($_SESSION['loginid']);

      $this->_logged_in = false;
      $this->_username  = GUEST_NAME;
      $this->_usergroup = GUEST_GROUP;
   }


   public function generateRandID()
   {
      return md5($this->generateRandStr(16));
   }


   private function generateRandStr($length)
   {
      $randstr = "";
      for($i=0; $i<$length; $i++){
         $randnum = mt_rand(0,61);
         if($randnum < 10){
            $randstr .= chr($randnum+48);
         }else if($randnum < 36){
            $randstr .= chr($randnum+55);
         }else{
            $randstr .= chr($randnum+61);
         }
      }
      return $randstr;
   }

   public function isAdmin()
   {



      if($this->_userinfo[group] == ADMIN_GROUP)
      {
        	return(TRUE);
      }
      else
      {
			return(FALSE);
      }

   }


  public function doRegister ($user, $pass, $email,  $birthdate ,$country, $group = 3,$code = '')
  {

      /* Username error checking */
      $field = "name";  //Use field name for username
      if(!$user || strlen($user = trim($user)) == 0)
      {
         $this->form->setError($field, $GLOBALS[lang][register_error_username_notfound]);
      }
      else
      {

         $user = stripslashes($user);
         if(strlen($user) < 5)
         {
            $this->form->setError($field, $GLOBALS['lang'][register_error_username_short]);
         }
         else if(strlen($user) > 30)
         {
            $this->form->setError($field, $GLOBALS['lang'][register_error_username_long]);
         }
         /* Check if username is already in use */
         else if($this->isusernameTaken($user))
         {
            $this->form->setError($field, $GLOBALS['lang'][register_error_username_ava]);
         }

      }


      /* Password error checking */
      $field = "password";
      if(!$pass)
      {
         $this->form->setError($field, $GLOBALS['lang'][register_error_password_notfound]);
      }
      else
      {

         $pass = stripslashes($pass);

         if(strlen($pass) < 6)
         {
            $this->form->setError($field, $GLOBALS['lang'][register_error_password_short]);
         }

      }


      /* Email error checking */
      $field = "email";
      if(!$email || strlen($email = trim($email)) == 0)
      {
         $this->form->setError($field, $GLOBALS['lang'][register_error_email_notfound]);
      }
      else
      {
         $regex = "^[_+a-z0-9-]+(\.[_+a-z0-9-]+)*"
                 ."@[a-z0-9-]+(\.[a-z0-9-]{1,})*"
                 ."\.([a-z]{2,}){1}$";
         if(!eregi($regex,$email))
         {
            $this->form->setError($field, $GLOBALS['lang'][register_error_email_error]);
         }
         /* Check if email is already in use */
         else if($this->isemailTaken($email))
         {
            $this->form->setError($field, $GLOBALS['lang'][register_error_email_notav]);
         }
         $email = stripslashes($email);
      }


      if($this->form->_num_errors > 0)
      {
         return false;  //Errors with form
      }
      /* No errors, add the new account */
      else
      {

      	 $birthdate = strtotime($birthdate);

         if($this->doaddNewUser($user, md5($pass), $email, $group ,$birthdate ,$country,$code))
         {
            return true;  //New user added succesfully

         }
         else
         {
            return false;  //Registration  failed
         }
      }

  }



  public function doEditAccount ($id ,$user, $pass, $email, $birthdate ,$country, $group = 3)
  {


      $uinfo = $this->doGetClientInfo($id,'id');

      /* Username error checking */
      $field = "name";  //Use field name for username
      if(!$user || strlen($user = trim($user)) == 0)
      {
         $this->form->setError($field, $GLOBALS[lang][register_error_username_notfound]);
      }
      else{

         if($uinfo[name] != $user)
         {
	         $user = stripslashes($user);
	         if(strlen($user) < 5)
	         {
	            $this->form->setError($field, $GLOBALS['lang'][register_error_username_short]);
	         }
	         else if(strlen($user) > 30)
	         {
	            $this->form->setError($field, $GLOBALS['lang'][register_error_username_long]);
	         }
	         /* Check if username is already in use */
	         else if($this->isusernameTaken($user))
	         {
	            $this->form->setError($field, $GLOBALS['lang'][register_error_username_ava]);
	         }
         }
      }


      /* Password error checking */
      $field = "password";
      if(!$pass)
      {
         $newpass = $uinfo[password];
      }
      else
      {

         $pass = stripslashes($pass);
         if(strlen($pass) < 6)
         {
            $this->form->setError($field, $GLOBALS['lang'][register_error_password_short]);
         }

         $newpass = md5($pass);
      }


      /* Email error checking */
      $field = "email";
      if(!$email || strlen($email = trim($email)) == 0)
      {
         $this->form->setError($field, $GLOBALS['lang'][register_error_email_notfound]);
      }
      else
      {
      	 if($uinfo[email] != $email)
      	 {
	         if(!eregi("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$", $email))
	         {
	            $this->form->setError($field, $GLOBALS['lang'][register_error_email_error]);
	         }
	         /* Check if email is already in use */
	         else if($this->isemailTaken($email))
	         {
	            $this->form->setError($field, $GLOBALS['lang'][register_error_email_notav]);
	         }
	         $email = stripslashes($email);
         }
      }



	  if($uinfo[birthdate] != $birthdate)
	  {
          $birthdate = strtotime($birthdate);
	  }


      if($this->form->_num_errors > 0)
      {
         return false;  //Errors with form
      }
      /* No errors, add the new account */
      else
      {
         if($this->doUpdateUser($id, $user, $newpass, $email, $group ,$birthdate ,$country))
         {
            return true;  //New user added succesfully

         }
         else
         {
            return false;  //Registration  failed
         }
      }

  }







}


?>